export const setWxOpenId = {
    methods: {
        setWxOpenId(e) {
            let isWechat = this.$utils.isWechat()
            let openId = this.$utils.getOpenId()
            if (!isWechat || openId) return false
            if (e.openid) {
                this.$utils.setOpenId(e.openid)
            } else {
                this.$api.getWechatOAuthInfo().then(res => {
                    window.location.href = res.wechat.auth_url + '?redirect=' + encodeURIComponent(
                        window.location.href)
                }).catch(e => {
                    this.$u.toast('加载公众号配置失败')
                })
            }
        }
    }
}

export const setWxMpOpenId = {
    methods: {
        setWxMpOpenId(e) {
            let that = this
            let openId = this.$utils.getOpenId()
            if (openId) return false
            uni.login({
                provider: 'weixin',
                onlyAuthorize: true,
                success: function(res) {
                    that.$api.getWechatMpSession({
                        code: res.code
                    }).then(res => {
                        that.$utils.setOpenId(res.session.openid)
                    }).catch(e => {
                        that.$u.toast('用户认证失败')
                    })
                }
            })
        }
    }
}