import Vue from 'vue'
import App from './App'
import VueClipboard from 'vue-clipboard2'
import * as Utils from '@/common/utils.js'
import * as Api from '@/common/api.js'

Vue.prototype.$utils = Utils
Vue.prototype.$api = Api

Vue.config.productionTip = false

Vue.filter('formatPrice', function(argv) {
    return Utils.formatPrice(argv)
})

Vue.filter('formatDuration', function(argv) {
    return Utils.formatDuration(argv)
})

Vue.filter('timeUsage', function(argv) {
    return Utils.timeUsage(argv)
})

Vue.filter('humanNumber', function(argv) {
    return Utils.humanNumber(argv)
})

Vue.filter('thumbAvatar', function(argv) {
    return Utils.thumbAvatar(argv)
})

Vue.filter('thumbCover', function(argv) {
    return Utils.thumbCover(argv)
})

Vue.filter('thumbSlide', function(argv) {
    return Common.thumbSlide(argv)
})

Vue.filter('courseModel', function(argv) {
    return Utils.courseModel(argv)
})

Vue.filter('courseLevel', function(argv) {
    return Utils.courseLevel(argv)
})

Vue.filter('examPaperLevel', function(argv) {
    return Utils.examPaperLevel(argv)
})

Vue.filter('examQuestionLevel', function(argv) {
    return Utils.examQuestionLevel(argv)
})

Vue.filter('examQuestionModel', function(argv) {
    return Utils.examQuestionModel(argv)
})

Vue.filter('examType', function(argv) {
    return Utils.examType(argv)
})

Vue.filter('examStatus', function(argv) {
    return Utils.examStatus(argv)
})

Vue.filter('orderStatus', function(argv) {
    return Utils.orderStatus(argv)
})

Vue.filter('refundStatus', function(argv) {
    return Utils.refundStatus(argv)
})

Vue.filter('withdrawStatus', function(argv) {
    return Utils.withdrawStatus(argv)
})

Vue.filter('invoiceStatus', function(argv) {
    return Utils.invoiceStatus(argv)
})

Vue.filter('saleItemType', function(argv) {
    return Utils.saleItemType(argv)
})

Vue.filter('certItemType', function(argv) {
    return Utils.certItemType(argv)
})

App.mpType = 'app'

import uView from 'uview-ui'

Vue.use(uView)
Vue.use(VueClipboard)

let mpShare = require('uview-ui/libs/mixin/mpShare.js')

Vue.mixin(mpShare)

const app = new Vue({
    ...App
})

app.$mount()
