import * as Config from '@/common/config.js'
import * as Storage from '@/common/storage.js'

export const getNowTime = () => {
    return Math.ceil(Date.now() / 1000)
}

export const formatPrice = (number) => {
    number = parseFloat(number)
    return '￥' + number.toFixed(2)
}

export const formatNumber = (number) => {
    number = number.toString()
    return number[1] ? number : '0' + number
}

export const randomColor = () => {
    let colors = [
        '#FFFFFF',
        '#E54256',
        '#FFE133',
        '#64DD17',
        '#39CCFF ',
        '#D500F9 ',
    ]
    let index = Math.floor(Math.random() * colors.length)
    return colors[index]
}

export const formatDuration = (number) => {
    let result = '00:00'
    if (number > 0) {
        let hours = Math.floor(number / 3600)
        let minutes = Math.floor((number - hours * 3600) / 60)
        let seconds = number % 60
        let format = []
        if (hours > 0) {
            format.push(formatNumber(hours))
        }
        if (minutes > 0) {
            format.push(formatNumber(minutes))
        }
        if (seconds >= 0) {
            format.push(formatNumber(seconds))
        }
        return format.join(':')
    }
    return result
}

export const timeUsage = (number) => {
    let result = '00分钟'
    if (number > 0) {
        let hours = Math.floor(number / 3600)
        let minutes = Math.floor((number - hours * 3600) / 60)
        let seconds = number % 60
        let format = []
        if (hours > 0) {
            format.push(`${hours}时`)
        }
        if (minutes > 0) {
            format.push(`${minutes}分`)
        }
        if (seconds > 0) {
            format.push(`${seconds}秒`)
        }
        result = format.join('')
    }
    return result
}

export const humanNumber = (number) => {
    let result = number
    if (number > 10000) {
        result = (number / 10000).toFixed(1) + '万'
    }
    return result
}

export const anonymous = (str, start = 0, length = 4) => {
    str = String(str)
    let end = start + length
    let result = []
    for (let i = 0; i < str.length; i++) {
        result[i] = i >= start && i < end ? '*' : str[i]
    }
    return result.join('')
}

export const thumbAvatar = (url) => {
    return `${url}!avatar_160`
}

export const thumbCover = (url) => {
    return `${url}!cover_270`
}

export const thumbSlide = (url) => {
    return `${url}!slide_1100`
}

export const withdrawChannel = (channel = null) => {
    const mapping = {
        '1': '支付宝',
        '2': '微信',
    }
    if (channel == null) return mapping
    return mapping[channel] ? mapping[channel] : '未知'
}

export const saleItemType = (type = null) => {
    const mapping = {
        '1': '课程',
        '2': '套餐',
        '3': '会员',
        '4': '试卷',
        '5': '专栏',
        '100': '实物',
    }
    if (type == null) return mapping
    return mapping[type] ? mapping[type] : '未知'
}

export const certItemType = (type = null) => {
    const mapping = {
        '1': '课程',
        '4': '考试',
    }
    if (type == null) return mapping
    return mapping[type] ? mapping[type] : '未知'
}

export const orderStatus = (status = null) => {
    const mapping = {
        '1': '待支付',
        '2': '发货中',
        '3': '已完成',
        '4': '已关闭',
        '5': '已退款',
    }
    if (status == null) return mapping
    return mapping[status] ? mapping[status] : '未知'
}

export const refundStatus = (status = null) => {
    const mapping = {
        '1': '待处理',
        '2': '已取消',
        '3': '退款中',
        '4': '已拒绝',
        '5': '已完成',
        '6': '已失败',
    }
    if (status == null) return mapping
    return mapping[status] ? mapping[status] : '未知'
}

export const withdrawStatus = (status = null) => {
    const mapping = {
        '1': '待处理',
        '2': '已取消',
        '3': '已审核',
        '4': '已拒绝',
        '5': '已完成',
        '6': '已失败',
    }
    if (status == null) return mapping
    return mapping[status] ? mapping[status] : '未知'
}

export const invoiceStatus = (status = null) => {
    const mapping = {
        '1': '待处理',
        '2': '已取消',
        '3': '已审核',
        '4': '已拒绝',
        '5': '已完成',
        '6': '已失败',
    }
    if (status == null) return mapping
    return mapping[status] ? mapping[status] : '未知'
}

export const invoiceUsageType = (type = null) => {
    const mapping = {
        '1': '增值税普票',
        '2': '增值税专票',
    }
    if (type == null) return mapping
    return mapping[type] ? mapping[type] : '未知'
}

export const invoiceHeadType = (type = null) => {
    const mapping = {
        '1': '个人',
        '2': '企业',
        '3': '组织',
    }
    if (type == null) return mapping
    return mapping[type] ? mapping[type] : '未知'
}

export const courseModel = (model = null) => {
    const mapping = {
        '1': '点播',
        '2': '直播',
        '3': '图文',
        '4': '面授',
        '5': '文档',
    }
    if (model == null) return mapping
    return mapping[model] ? mapping[model] : '未知'
}

export const courseLevel = (level = null) => {
    const mapping = {
        '1': '入门',
        '2': '初级',
        '3': '中级',
        '4': '高级',
    }
    if (level == null) return mapping
    return mapping[level] ? mapping[level] : '未知'
}

export const examPaperLevel = (level = null) => {
    const mapping = {
        '1': '初级',
        '2': '中级',
        '3': '高级',
    }
    if (level == null) return mapping
    return mapping[level] ? mapping[level] : '未知'
}

export const examQuestionLevel = (level = null) => {
    const mapping = {
        '1': '初级',
        '2': '中级',
        '3': '高级',
    }
    if (level == null) return mapping
    return mapping[level] ? mapping[level] : '未知'
}

export const examQuestionModel = (model = null) => {
    const mapping = {
        '1': '单择题',
        '2': '多选题',
        '3': '判断题',
        '4': '填空题',
        '5': '简答题',
        '9': '题帽题',
    }
    if (model == null) return mapping
    return mapping[model] ? mapping[model] : '未知'
}

export const examType = (type = null) => {
    const mapping = {
        '1': '模拟考试',
        '2': '同步练习',
    }
    if (type == null) return mapping
    return mapping[type] ? mapping[type] : '未知'
}

export const examStatus = (status = null) => {
    const mapping = {
        '1': '未开始',
        '2': '进行中',
        '3': '待批阅',
        '4': '已完成',
    }
    if (status == null) return mapping
    return mapping[status] ? mapping[status] : '未知'
}

export const gotoExamPaper = (paper) => {
    if (paper.exam_type == 1) {
        redirect('/pages/exam/paper/mock-info', {
            id: paper.id
        })
    } else if (paper.exam_type == 2) {
        redirect('/pages/exam/paper/unit-info', {
            id: paper.id
        })
    } else {
        uni.showToast({
            title: '不支持的试卷类型'
        })
    }
}

export const getDistShareUrl = (userId, itemId, itemType) => {
    let url = ''
    let page = '/pages/index/index'
    if (itemType == 1) {
        page = '/pages/course/info'
    } else if (itemType == 2) {
        page = '/pages/package/info'
    } else if (itemType == 3) {
        page = '/pages/vip/index'
    } else if (itemType == 4) {
        page = '/pages/exam/paper/info'
    } else if (itemType == 5) {
        page = '/pages/article/info'
    }
    let query = httpBuildQuery({
        id: itemId,
        referer: userId,
    })
    // #ifdef H5
    let href = window.location.href.split('#')
    url = href[0] + '#' + page + '?' + query
    // #endif
    // #ifdef MP-WEIXIN
    url = page + '?' + query
    // #endif
    return url
}

export const getChapterTargetUrl = (chapter) => {
    let mapping = {
        '1': 'vod',
        '2': 'live',
        '3': 'read',
        '5': 'doc',
    }
    let target = mapping[chapter.model] ? mapping[chapter.model] : 'vod'
    if (chapter.model == 2 && chapter.attrs.stream.status == 'inactive' && chapter.attrs.playback.ready == 1) {
        target = 'vod'
    }
    return `/pages/chapter/${target}?id=${chapter.id}`
}

export const redirect = (url, params = {}) => {
    const tabUrls = [
        '/pages/index/index',
        '/pages/course/list',
        '/pages/notification/index',
        '/pages/me/index',
    ]
    if (tabUrls.indexOf(url) != -1) {
        uni.switchTab({
            url: url
        })
        return false
    }
    if (Object.keys(params).length > 0) {
        if (url.indexOf('?') == -1) {
            url += '?' + httpBuildQuery(params)
        } else {
            url += '&' + httpBuildQuery(params)
        }
    }
    if (url.includes('://')) {
        uni.navigateTo({
            url: '/pages/page/web-view?url=' + encodeURIComponent(url)
        })
    } else if (url.startsWith('/pages')) {
        uni.navigateTo({
            url: url
        })
    } else {
        uni.showToast({
            title: '不支持的协议类型'
        })
    }
}

export const getPlatform = () => {
    let platform = 'OTHER'
    // #ifdef H5
    platform = 'H5'
    // #endif
    // #ifdef MP-WEIXIN
    platform = 'MP-WEIXIN'
    // #endif
    // #ifdef MP-ALIPAY
    platform = 'MP-ALIPAY'
    // #endif
    // #ifdef MP-MP-BAIDU
    platform = 'MP-BAIDU'
    // #endif
    // #ifdef MP-TOUTIAO
    platform = 'MP-TOUTIAO'
    // #endif
    // #ifdef APP-PLUS
    platform = uni.getSystemInfoSync().platform
    // #endif
    return platform
}

export const httpBuildQuery = (params) => {
    let result = ''
    if (Object.keys(params).length > 0) {
        let arr = []
        for (let key in params) {
            arr.push(`${key}=${params[key]}`)
        }
        result = arr.sort().join('&')
    }
    return result
}

export const arrayFlip = (obj) => {
    let result = []
    for (let k in obj) {
        result[obj[k]] = k
    }
    return result
}

export const getApiBaseUrl = () => {
    return Config.apiBaseUrl
}

export const getToken = () => {
    let key = Storage.cacheKey.token
    return Storage.get(key)
}

export const setToken = (value) => {
    let key = Storage.cacheKey.token
    return Storage.set(key, value)
}

export const clearToken = (value) => {
    let key = Storage.cacheKey.token
    return Storage.set(key, '')
}

export const isLogin = () => {
    if (getToken() == '') {
        return false
    }
    return true
}

export const checkLogin = (opt = {}) => {
    let redirect = '/pages/index/index'
    if (opt.redirect && opt.redirect != '') {
        redirect = opt.redirect
    }
    if (getToken() == '') {
        uni.navigateTo({
            url: '/pages/account/login?redirect=' + encodeURIComponent(redirect)
        })
        return false
    }
    if (opt.success && typeof opt.success == 'function') {
        opt.success()
    }
}

export const isWechat = () => {
    // #ifdef H5
    let ua = navigator.userAgent.toLowerCase()
    return ua.match(/MicroMessenger/i) == 'micromessenger'
    // #endif
    return false
}

export const getOpenId = () => {
    let key = Storage.cacheKey.openid
    return Storage.get(key)
}

export const setOpenId = (value) => {
    let key = Storage.cacheKey.openid
    return Storage.set(key, value)
}

export const clearOpenId = (value) => {
    let key = Storage.cacheKey.openid
    return Storage.set(key, '')
}

export const getReferer = () => {
    let key = Storage.cacheKey.referer
    return Storage.get(key)
}

export const setReferer = (value) => {
    let key = Storage.cacheKey.referer
    return Storage.set(key, value)
}