import * as About from '@/common/about.js'
import * as Config from '@/common/config.js'
import * as Utils from '@/common/utils.js'
import * as Storage from '@/common/storage.js'

export const search = (params) => {
    return httpGet('/search', params)
}

export const getSiteSetting = () => {
    return httpGet('/setting/site')
}

export const getMobileSetting = () => {
    return httpGet('/setting/mobile')
}

export const getPaymentSetting = () => {
    return httpGet('/setting/payment')
}

export const getAffiliateSetting = () => {
    return httpGet('/setting/affiliate')
}

export const getWithdrawSetting = () => {
    return httpGet('/setting/withdraw')
}

export const getInvoiceSetting = () => {
    return httpGet('/setting/invoice')
}

export const getPointSetting = () => {
    return httpGet('/setting/point')
}

export const getSignupSetting = () => {
    return httpGet('/setting/signup')
}

export const getLicenseInfo = () => {
    return httpGet('/license/info')
}

export const getSocketInfo = () => {
    return httpGet('/socket/info')
}

export const getWechatOAuthInfo = () => {
    return httpGet('/oauth/wechat/info')
}

export const getWechatMpSession = (params) => {
    return httpGet('/mp/wechat/session', params)
}

export const getVipOptions = () => {
    return httpGet('/vip/options')
}

export const getVipCourses = (params) => {
    return httpGet('/vip/courses', params)
}

export const getVipUsers = (params) => {
    return httpGet('/vip/users', params)
}

export const getHelpList = () => {
    return httpGet('/help/list')
}

export const getHelpInfo = (id) => {
    return httpGet(`/help/${id}/info`)
}

export const getPageInfo = (id) => {
    return httpGet(`/page/${id}/info`)
}

export const getIndexSlides = () => {
    return httpGet('/index/slides')
}

export const getIndexLives = () => {
    return httpGet('/index/lives')
}

export const getIndexTeachers = () => {
    return httpGet('/index/teachers')
}

export const getIndexArticles = () => {
    return httpGet('/index/articles')
}

export const getIndexQuestions = () => {
    return httpGet('/index/questions')
}

export const getIndexNewCourses = () => {
    return httpGet('/index/courses/new')
}

export const getIndexFreeCourses = () => {
    return httpGet('/index/courses/free')
}

export const getIndexFeaturedCourses = () => {
    return httpGet('/index/courses/featured')
}

export const getCertUserInfo = (sn) => {
    return httpGet('/cert/user/info', {
        sn: sn
    })
}

export const getExamPaperCategories = () => {
    return httpGet('/exam/paper/categories')
}

export const getExamPaperList = (params = {}) => {
    return httpGet('/exam/paper/list', params)
}

export const getExamPaperInfo = (id) => {
    return httpGet(`/exam/paper/${id}/info`)
}

export const favoriteExamPaper = (id) => {
    return httpPost(`/exam/paper/${id}/favorite`)
}

export const joinExamPaper = (id) => {
    return httpPost(`/exam/paper/${id}/join`)
}

export const getExamPaperMockHistory = (id, params = {}) => {
    return httpGet(`/exam/paper/${id}/mock/history`, params)
}

export const getMockExamInfo = (id) => {
    return httpGet(`/exam/${id}/mock/info`)
}

export const getUnitExamInfo = (id) => {
    return httpGet(`/exam/${id}/unit/info`)
}

export const getUnitExamFreshQuestions = (id, params = {}) => {
    return httpGet(`/exam/${id}/unit/questions/fresh`, params)
}

export const getUnitExamHistoryQuestions = (id, params = {}) => {
    return httpGet(`/exam/${id}/unit/questions/history`, params)
}

export const getMistakeExamQuestions = (params = {}) => {
    return httpGet(`/exam/mistake/questions`, params)
}

export const getFavoriteExamQuestions = (params = {}) => {
    return httpGet(`/exam/favorite/questions`, params)
}

export const submitMockExamPaper = (id, params = {}) => {
    return httpPost(`/exam/${id}/mock/paper/submit`, params)
}

export const submitMockExamAnswer = (id, params = {}) => {
    return httpPost(`/exam/${id}/mock/answer/submit`, params)
}

export const submitUnitExamAnswer = (id, params = {}) => {
    return httpPost(`/exam/${id}/unit/answer/submit`, params)
}

export const resetUnitExam = (id) => {
    return httpPost(`/exam/${id}/unit/reset`)
}

export const getExamQuestionInfo = (id) => {
    return httpGet(`/exam/question/${id}/info`)
}

export const checkExamQuestionAnswer = (id, params = {}) => {
    return httpPost(`/exam/question/${id}/answer/check`, params)
}

export const favoriteExamQuestion = (id) => {
    return httpPost(`/exam/question/${id}/favorite`)
}

export const mistakeExamQuestion = (id) => {
    return httpPost(`/exam/question/${id}/mistake`)
}

export const getArticleCategories = () => {
    return httpGet('/article/categories')
}

export const getArticleTags = () => {
    return httpGet('/article/tags')
}

export const getArticleList = (params = {}) => {
    return httpGet('/article/list', params)
}

export const getArticleInfo = (id) => {
    return httpGet(`/article/${id}/info`)
}

export const getArticleComments = (id, params = {}) => {
    return httpGet(`/article/${id}/comments`, params)
}

export const createArticle = (params = {}) => {
    return httpPost('/article/create', params)
}

export const favoriteArticle = (id) => {
    return httpPost(`/article/${id}/favorite`)
}

export const likeArticle = (id) => {
    return httpPost(`/article/${id}/like`)
}

export const deleteArticle = (id) => {
    return httpPost(`/article/${id}/delete`)
}

export const getQuestionCategories = () => {
    return httpGet('/question/categories')
}

export const getQuestionTags = () => {
    return httpGet('/question/tags')
}

export const getQuestionList = (params = {}) => {
    return httpGet('/question/list', params)
}

export const getQuestionInfo = (id) => {
    return httpGet(`/question/${id}/info`)
}

export const getQuestionAnswers = (id, params = {}) => {
    return httpGet(`/question/${id}/answers`, params)
}

export const getQuestionComments = (id, params = {}) => {
    return httpGet(`/question/${id}/comments`, params)
}

export const createQuestion = (params = {}) => {
    return httpPost('/question/create', params)
}

export const favoriteQuestion = (id) => {
    return httpPost(`/question/${id}/favorite`)
}

export const likeQuestion = (id) => {
    return httpPost(`/question/${id}/like`)
}

export const deleteQuestion = (id) => {
    return httpPost(`/question/${id}/delete`)
}

export const getAnswerInfo = (id) => {
    return httpGet(`/answer/${id}/info`)
}

export const getAnswerComments = (id, params = {}) => {
    return httpGet(`/answer/${id}/comments`, params)
}

export const createAnswer = (params = {}) => {
    return httpPost('/answer/create', params)
}

export const likeAnswer = (id) => {
    return httpPost(`/answer/${id}/like`)
}

export const deleteAnswer = (id) => {
    return httpPost(`/answer/${id}/delete`)
}

export const getCommentInfo = (id) => {
    return httpGet(`/comment/${id}/info`)
}

export const getCommentReplies = (id, params = {}) => {
    return httpGet(`/comment/${id}/replies`, params)
}

export const createDanmu = (params = {}) => {
    return httpPost('/danmu/create', params)
}

export const createComment = (params = {}) => {
    return httpPost('/comment/create', params)
}

export const replyComment = (id, params = {}) => {
    return httpPost(`/comment/${id}/reply`, params)
}

export const likeComment = (id) => {
    return httpPost(`/comment/${id}/like`)
}

export const deleteComment = (id) => {
    return httpPost(`/comment/${id}/delete`)
}

export const getPackageInfo = (id) => {
    return httpGet(`/package/${id}/info`)
}

export const getPackageCourses = (id) => {
    return httpGet(`/package/${id}/courses`)
}

export const getCourseCategories = () => {
    return httpGet('/course/categories')
}

export const getCourseTags = () => {
    return httpGet('/course/tags')
}

export const getCourseList = (params = {}) => {
    return httpGet('/course/list', params)
}

export const getCourseLastStudy = (id) => {
    return httpGet(`/course/${id}/last/study`)
}

export const getCourseInfo = (id) => {
    return httpGet(`/course/${id}/info`)
}

export const getCoursePoster = (id) => {
    return httpGet(`/course/${id}/poster`)
}

export const getCourseChapters = (id) => {
    return httpGet(`/course/${id}/chapters`)
}

export const getCourseExamPapers = (id) => {
    return httpGet(`/course/${id}/exam/papers`)
}

export const getCoursePackages = (id) => {
    return httpGet(`/course/${id}/packages`)
}

export const getCourseReviews = (id, params = {}) => {
    return httpGet(`/course/${id}/reviews`, params)
}

export const getCourseConsults = (id, params = {}) => {
    return httpGet(`/course/${id}/consults`, params)
}

export const favoriteCourse = (id) => {
    return httpPost(`/course/${id}/favorite`)
}

export const getChapterInfo = (id) => {
    return httpGet(`/chapter/${id}/info`)
}

export const getChapterDanmus = (id, params = {}) => {
    return httpGet(`/chapter/${id}/danmus`, params)
}

export const getChapterComments = (id, params = {}) => {
    return httpGet(`/chapter/${id}/comments`, params)
}

export const likeChapter = (id) => {
    return httpPost(`/chapter/${id}/like`)
}

export const learningChapter = (id, params) => {
    return httpPost(`/chapter/${id}/learning`, params)
}

export const getLiveList = (params) => {
    return httpGet('/live/list', params)
}

export const getLiveChats = (id) => {
    return httpGet(`/live/${id}/chats`)
}

export const bindLiveUser = (id, params) => {
    return httpPost(`/live/${id}/user/bind`, params)
}

export const sendLiveMessage = (id, params) => {
    return httpPost(`/live/${id}/msg/send`, params)
}

export const createConsult = (params) => {
    return httpPost('/consult/create', params)
}

export const getConsultInfo = (id) => {
    return httpGet(`/consult/${id}/info`)
}

export const updateConsult = (id, params) => {
    return httpPost(`/consult/${id}/update`, params)
}

export const deleteConsult = (id) => {
    return httpPost(`/consult/${id}/delete`)
}

export const likeConsult = (id) => {
    return httpPost(`/consult/${id}/like`)
}

export const createReview = (params) => {
    return httpPost('/review/create', params)
}

export const getReviewInfo = (id) => {
    return httpGet(`/review/${id}/info`)
}

export const updateReview = (id, params) => {
    return httpPost(`/review/${id}/update`, params)
}

export const deleteReview = (id) => {
    return httpPost(`/review/${id}/delete`)
}

export const likeReview = (id) => {
    return httpPost(`/review/${id}/like`)
}

export const unlikeReview = (id) => {
    return httpPost(`/review/${id}/unlike`)
}

export const getCouponList = (params) => {
    return httpGet('/coupon/list', params)
}

export const claimCoupon = (id) => {
    return httpPost(`/coupon/${id}/claim`)
}

export const redeemCoupon = (params) => {
    return httpPost('/coupon/redeem', params)
}

export const getGrouponList = (params = {}) => {
    return httpGet('/groupon/list', params)
}

export const getGrouponInfo = (id) => {
    return httpGet(`/groupon/${id}/info`)
}

export const getGrouponTeams = (id, params = {}) => {
    return httpGet(`/groupon/${id}/teams`)
}

export const createGrouponOrder = (id, params) => {
    return httpPost(`/groupon/${id}/order`, params)
}

export const getDistList = (params = {}) => {
    return httpGet('/dist/list', params)
}

export const getDistPoster = (id) => {
    return httpGet(`/dist/${id}/poster`)
}

export const getDistShare = (id) => {
    return httpGet(`/dist/${id}/share`)
}

export const getPointGiftList = (params = {}) => {
    return httpGet('/point/gift/list', params)
}

export const getPointGiftInfo = (id) => {
    return httpGet(`/point/gift/${id}/info`)
}

export const redeemPointGift = (id, params = {}) => {
    return httpPost(`/point/gift/${id}/redeem`, params)
}

export const redeemDigitalCard = (params = {}) => {
    return httpPost('/digital/card/redeem', params)
}

export const getFlashSaleList = (params = {}) => {
    return httpGet('/flash/sale/list', params)
}

export const getFlashSaleInfo = (id) => {
    return httpGet(`/flash/sale/${id}/info`)
}

export const createFlashSaleOrder = (id, params) => {
    return httpPost(`/flash/sale/${id}/order`, params)
}

export const getOrderInfo = (sn) => {
    return httpGet('/order/info', {
        sn: sn
    })
}

export const getOrderConfirm = (itemId, itemType) => {
    return httpGet('/order/confirm', {
        item_id: itemId,
        item_type: itemType
    })
}

export const getOrderCouponList = (itemId, itemType) => {
    return httpGet('/order/coupon/list', {
        item_id: itemId,
        item_type: itemType
    })
}

export const applyOrderCoupon = (params) => {
    return httpPost('/order/coupon/apply', params)
}

export const createOrder = (params) => {
    return httpPost('/order/create', params)
}

export const cancelOrder = (sn) => {
    return httpPost('/order/cancel', {
        sn: sn
    })
}

export const getRefundConfirm = (sn) => {
    return httpGet('/refund/confirm', {
        sn: sn
    })
}

export const getRefundInfo = (sn) => {
    return httpGet('/refund/info', {
        sn: sn
    })
}

export const createRefund = (params) => {
    return httpPost('/refund/create', params)
}

export const cancelRefund = (sn) => {
    return httpPost('/refund/cancel', {
        sn: sn
    })
}

export const getTradeInfo = (sn) => {
    return httpGet('/trade/info', {
        sn: sn
    })
}

export const createH5Trade = (params) => {
    return httpPost('/trade/h5/create', params)
}

export const createMpTrade = (params) => {
    return httpPost('/trade/mp/create', params)
}

export const createMiniTrade = (params) => {
    return httpPost('/trade/mini/create', params)
}

export const createAppTrade = (params) => {
    return httpPost('/trade/app/create', params)
}

export const getAffiliateSaleTeams = (params = {}) => {
    return httpGet('/uc/affiliate/sale/teams', params)
}

export const getAffiliateSaleTrend = (params = {}) => {
    return httpGet('/uc/affiliate/sale/trend', params)
}

export const createWithdrawAccount = (params) => {
    return httpPost('/withdraw/account/create', params)
}

export const verifyWithdrawAccount = (id) => {
    return httpPost(`/withdraw/account/${id}/verify`)
}

export const deleteWithdrawAccount = (id) => {
    return httpPost(`/withdraw/account/${id}/delete`)
}

export const createInvoiceAccount = (params) => {
    return httpPost('/invoice/account/create', params)
}

export const deleteInvoiceAccount = (id) => {
    return httpPost(`/invoice/account/${id}/delete`)
}

export const createWithdraw = (params) => {
    return httpPost('/withdraw/create', params)
}

export const cancelWithdraw = (id) => {
    return httpPost(`/withdraw/${id}/cancel`)
}

export const createInvoice = (params) => {
    return httpPost('/invoice/create', params)
}

export const cancelInvoice = (id) => {
    return httpPost(`/invoice/${id}/cancel`)
}

export const createUserContact = (params = {}) => {
    return httpPost('/user/contact/create', params)
}

export const getUserContactInfo = (id) => {
    return httpGet(`/user/contact/${id}/info`)
}

export const deleteUserContact = (id) => {
    return httpPost(`/user/contact/${id}/delete`)
}

export const getTeacherList = (params = {}) => {
    return httpGet('/teacher/list', params)
}

export const getTeacherInfo = (id) => {
    return httpGet(`/teacher/${id}/info`)
}

export const getTeacherCourses = (id, params = {}) => {
    return httpGet(`/teacher/${id}/courses`, params)
}

export const getUserInfo = (id) => {
    return httpGet(`/user/${id}/info`)
}

export const getUserStudyExamPapers = (id, params = {}) => {
    return httpGet(`/user/${id}/study/exam/papers`, params)
}

export const getUserStudyCourses = (id, params = {}) => {
    return httpGet(`/user/${id}/study/courses`, params)
}

export const getUserStudyArticles = (id, params = {}) => {
    return httpGet(`/user/${id}/study/articles`, params)
}

export const getUserQuestions = (id, params = {}) => {
    return httpGet(`/user/${id}/questions`, params)
}

export const getUserAnswers = (id, params = {}) => {
    return httpGet(`/user/${id}/answers`, params)
}

export const getMyProfile = () => {
    return httpGet('/uc/profile')
}

export const getMyAccount = () => {
    return httpGet('/uc/account')
}

export const getMyBalance = () => {
    return httpGet('/uc/balance')
}

export const getMyCoupons = (params = {}) => {
    return httpGet('/uc/coupons', params)
}

export const getMyCashHistory = (params = {}) => {
    return httpGet('/uc/cash/history', params)
}

export const getMyPointHistory = (params = {}) => {
    return httpGet('/uc/point/history', params)
}

export const getMyDigitalRedeems = (params = {}) => {
    return httpGet('/uc/digital/redeems', params)
}

export const getMyPointRedeems = (params = {}) => {
    return httpGet('/uc/point/redeems', params)
}

export const getMyOrders = (params = {}) => {
    return httpGet('/uc/orders', params)
}

export const getMyRefunds = (params = {}) => {
    return httpGet('/uc/refunds', params)
}

export const getMyStudyExamPapers = (params = {}) => {
    return httpGet('/uc/study/exam/papers', params)
}

export const getMyStudyCourses = (params = {}) => {
    return httpGet('/uc/study/courses', params)
}

export const getMyStudyArticles = (params = {}) => {
    return httpGet('/uc/study/articles', params)
}

export const getMyQuestions = (params = {}) => {
    return httpGet('/uc/questions', params)
}

export const getMyAnswers = (params = {}) => {
    return httpGet('/uc/answers', params)
}

export const getMyConsults = (params = {}) => {
    return httpGet('/uc/consults', params)
}

export const getMyReviews = (params = {}) => {
    return httpGet('/uc/reviews', params)
}

export const getMyFavorites = (params = {}) => {
    return httpGet('/uc/favorites', params)
}

export const getMyCertificates = (params = {}) => {
    return httpGet('/uc/certificates', params)
}

export const getMyContacts = (params = {}) => {
    return httpGet('/uc/contacts', params)
}

export const getMyInvoices = (params = {}) => {
    return httpGet('/uc/invoices', params)
}

export const getMyWithdraws = (params = {}) => {
    return httpGet('/uc/withdraws', params)
}

export const getMyInvoiceAccounts = (params = {}) => {
    return httpGet('/uc/invoice/accounts', params)
}

export const getMyWithdrawAccounts = (params = {}) => {
    return httpGet('/uc/withdraw/accounts', params)
}

export const getMyNotifications = (params = {}) => {
    return httpGet('/uc/notifications', params)
}

export const getMyNotifyStats = (params = {}) => {
    return httpGet('/uc/notify/stats', params)
}

export const updateMyProfile = (params = {}) => {
    return httpPost('/uc/profile/update', params)
}

export const updateMyOnline = (params = {}) => {
    return httpPost('/uc/online', params)
}

export const registerAccount = (params = {}) => {
    return httpPost('/account/register', params)
}

export const loginByPassword = (params = {}) => {
    return httpPost('/account/password/login', params)
}

export const loginByVerify = (params = {}) => {
    return httpPost('/account/verify/login', params)
}

export const logoutAccount = (params = {}) => {
    return httpPost('/account/logout', params)
}

export const resetPassword = (params = {}) => {
    return httpPost('/account/password/reset', params)
}

export const updatePhone = (params = {}) => {
    return httpPost('/account/phone/update', params)
}

export const updateEmail = (params = {}) => {
    return httpPost('/account/email/update', params)
}

export const updatePassword = (params = {}) => {
    return httpPost('/account/password/update', params)
}

export const getVerifyCaptcha = () => {
    return httpGet('/verify/captcha')
}

export const sendVerifyCode = (params = {}) => {
    return httpPost('/verify/code', params)
}

export const sendSmsVerifyCode = (params = {}) => {
    return httpPost('/verify/sms/code', params)
}

export const sendMailVerifyCode = (params = {}) => {
    return httpPost('/verify/mail/code', params)
}

export const uploadAvatarImage = (filePath) => {
    return new Promise((resolve, reject) => {
        uni.uploadFile({
            url: Config.apiBaseUrl + '/upload/avatar/img',
            name: 'file',
            filePath: filePath,
            success: (res) => {
                resolve(res)
            },
            fail: (e) => {
                reject(e)
            }
        })
    })
}

const httpGet = (path, params = {}, header = {}) => {
    return httpRequest(path, params, 'GET', header)
}

const httpPost = (path, params = {}, header = {}) => {
    return httpRequest(path, params, 'POST', header)
}

const httpRequest = (path, params = {}, method = 'GET', header = {}) => {

    let url = Config.apiBaseUrl + path

    header['X-Version'] = About.appInfo.version
    header['X-Platform'] = Utils.getPlatform()
    header['X-Timestamp'] = Utils.getNowTime()
    header['X-Token'] = Storage.get(Storage.cacheKey.token)
    header['X-Referer'] = Storage.get(Storage.cacheKey.referer)

    return new Promise(function(resolve, reject) {
        uni.request({
            url: url,
            data: params,
            method: method,
            header: header,
            success: function(res) {
                if (res.statusCode == 200) {
                    if (res.data.code == 0) {
                        resolve(res.data)
                    } else {
                        reject(res.data)
                    }
                } else if (res.statusCode == 401) {
                    Utils.clearToken()
                    uni.navigateTo({
                        url: '/pages/account/login'
                    })
                } else {
                    reject(res.data)
                }
            },
            fail: function(err) {
                reject(err)
            }
        })
    })
}